﻿<?xml version='1.0' encoding='utf-8' standalone='yes'?>
<!-- 
This files defines a set of ETW (Event Tracing for Windows) providers that can
be used to emit events into an ETW stream for recording with xperf or logman.
When used with the xperf kernel providers these can help investigate performance
problems by adding arbitrary context to the kernel data.

This file is built using the following custom build tool command line:
  mc.exe -um %(Filename)%(Extension) -z %(Filename)Generated 
The main outputs are:
  %(Filename)Generated.h;%(Filename)Generated.rc

The header file should be included by one or more source files, and the resource
file should either be added to your project or included into an existing resource
file.

The header file contains macros and functions to emit events. The 

For information on writing an instrumentation manifest see
http://msdn.microsoft.com/en-us/library/dd996930(VS.85).aspx
For more information on ETW see http://msdn.microsoft.com/en-us/magazine/cc163437.aspx
and http://msdn.microsoft.com/en-us/library/aa363668(VS.85).aspx 

Documentation of the data types available for event payload templates is here:
http://msdn.microsoft.com/en-us/library/aa382774(v=VS.85).aspx 
 
See also the Windows Platform SDK SimpleProvider and AdvancedProvider samples
and the Scenario library at http://archive.msdn.microsoft.com/Scenario
      
Before recording traces you need to execute these commands to register the provider:
xcopy /y yourgame.exe %temp%
wevtutil um etwprovider.man
wevtutil im etwprovider.man

The "wevtutul um" command is to unregister previous versions of these providers, to
allow arbitrary changes to be made.
-->
<instrumentationManifest xmlns="http://schemas.microsoft.com/win/2004/08/events">
  <instrumentation
      xmlns:win="http://manifests.microsoft.com/win/2004/08/windows/events"
      xmlns:xs="http://www.w3.org/2001/XMLSchema"
      xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
    <events xmlns="http://schemas.microsoft.com/win/2004/08/events">
      <provider
          guid="{AD62181D-781E-4F0E-BF1B-32132928CF4C}"
          name="PerformanceAPI"
          symbol="PERFORMANCEAPI"
          messageFileName="%temp%\PerformanceAPIProviders.dll"
          resourceFileName="%temp%\PerformanceAPIProviders.dll" >
        <templates>
          <template tid="InstrumentationStartEvent">
            <data inType="win:AnsiString" name="Name" />
			<data inType="win:AnsiString" name="Context" />
          </template>
          <template tid="InstrumentationStartColorEvent">
            <data inType="win:AnsiString" name="Name" />
			<data inType="win:AnsiString" name="Context" />
			<data inType="win:UInt32" name="Color" />
          </template>				
          <template tid="InstrumentationStartColorNEvent">
			<data inType="win:UInt16" name="NameLength" />
            <data inType="win:AnsiString" name="Name" length="NameLength" />
			<data inType="win:UInt16" name="ContextLength" />
			<data inType="win:AnsiString" name="Context" length="ContextLength" />
			<data inType="win:UInt32" name="Color" />
          </template>			
          <template tid="InstrumentationStartWideEvent">
            <data inType="win:UnicodeString" name="Name" />
			<data inType="win:UnicodeString" name="Context" />
          </template>
          <template tid="InstrumentationStartColorWideEvent">
            <data inType="win:UnicodeString" name="Name" />
			<data inType="win:UnicodeString" name="Context" />
			<data inType="win:UInt32" name="Color" />
          </template>				
          <template tid="InstrumentationStartColorWideNEvent">
			<data inType="win:UInt16" name="NameLength" />
            <data inType="win:UnicodeString" name="Name" length="NameLength" />
			<data inType="win:UInt16" name="ContextLength" />
			<data inType="win:UnicodeString" name="Context" length="ContextLength" />
			<data inType="win:UInt32" name="Color" />
          </template>			
		  <template tid="InstrumentationEndEvent">
		  </template>
		</templates>
        <keywords>
          <keyword name="HighFrequency" mask="0x2" />
          <keyword name="NormalFrequency" mask="0x1" />
        </keywords>
        <opcodes>
          <opcode name="InstrumentationStartOpcode" symbol="PerformanceAPI_InstrumentationStartOpcode" value="12"/>
		  <opcode name="InstrumentationEndOpcode" symbol="PerformanceAPI_InstrumentationEndOpcode" value="13"/>
		  <opcode name="InstrumentationStartWideOpcode" symbol="PerformanceAPI_InstrumentationStartWideOpcode" value="14"/>
		  <opcode name="InstrumentationStartColorOpcode" symbol="PerformanceAPI_InstrumentationStartColorOpcode" value="15"/>
		  <opcode name="InstrumentationStartColorWideOpcode" symbol="PerformanceAPI_InstrumentationStartColorWideOpcode" value="16"/>
		  <opcode name="InstrumentationStartColorNOpcode" symbol="PerformanceAPI_InstrumentationStartColorNOpcode" value="17"/>
		  <opcode name="InstrumentationStartColorWideNOpcode" symbol="PerformanceAPI_InstrumentationStartColorWideNOpcode" value="18"/>
		</opcodes>
        <tasks>
          <task name="Instrumentation" symbol="PerformanceAPI_Instrumentation_Task" value="1" eventGUID="{25B32ED0-A062-467A-87C6-B47B79FC906D}"/>
        </tasks>
        <events>
          <event symbol="PerformanceAPI_InstrumentationStart" template="InstrumentationStartEvent" value="100" task="Instrumentation" opcode="InstrumentationStartOpcode" keywords="NormalFrequency" />
		  <event symbol="PerformanceAPI_InstrumentationEnd" template="InstrumentationEndEvent" value="101" task="Instrumentation" opcode="InstrumentationEndOpcode" keywords="NormalFrequency" />
   		  <event symbol="PerformanceAPI_InstrumentationStartWide" template="InstrumentationStartWideEvent" value="102" task="Instrumentation" opcode="InstrumentationStartWideOpcode" keywords="NormalFrequency" />
		  <event symbol="PerformanceAPI_InstrumentationStartColor" template="InstrumentationStartColorEvent" value="103" task="Instrumentation" opcode="InstrumentationStartColorOpcode" keywords="NormalFrequency" />
		  <event symbol="PerformanceAPI_InstrumentationStartColorWide" template="InstrumentationStartColorWideEvent" value="104" task="Instrumentation" opcode="InstrumentationStartColorWideOpcode" keywords="NormalFrequency" />
		  <event symbol="PerformanceAPI_InstrumentationStartColorN" template="InstrumentationStartColorNEvent" value="105" task="Instrumentation" opcode="InstrumentationStartColorNOpcode" keywords="NormalFrequency" />
		  <event symbol="PerformanceAPI_InstrumentationStartColorWideN" template="InstrumentationStartColorWideNEvent" value="106" task="Instrumentation" opcode="InstrumentationStartColorWideNOpcode" keywords="NormalFrequency" />
		</events>
      </provider>
		
	  <provider
          guid="{A07DC94F-631F-41A1-94CA-5AFE40A09778}"
          name="PerformanceAPINoStack"
          symbol="PERFORMANCEAPI_NOSTACK"
          messageFileName="%temp%\PerformanceAPIProviders.dll"
          resourceFileName="%temp%\PerformanceAPIProviders.dll" >
        <templates>
	      <template tid="APIVersionEvent">
		    <data inType="win:Int32" name="MajorVersion" />
			<data inType="win:Int32" name="MinorVersion" />
		  </template>
   		  <template tid="SetThreadNameEvent">
		    <data inType="win:AnsiString" name="Name" />
			<data inType="win:Int32" name="ThreadID" />
		  </template>
   		  <template tid="SetThreadNameNEvent">
			<data inType="win:UInt16" name="NameLength" />
            <data inType="win:AnsiString" name="Name" length="NameLength" />
			<data inType="win:Int32" name="ThreadID" />
		  </template>
		  <template tid="RegisterFiberEvent">
		  	<data inType="win:UInt64" name="FiberID" />
		  </template>
		  <template tid="UnregisterFiberEvent">
		  	<data inType="win:UInt64" name="FiberID" />
		  </template>			
		  <template tid="FiberSwitchOutEvent">
			<data inType="win:UInt64" name="CurrentFiberID" />
			<data inType="win:UInt64" name="NewFiberID" />
		  </template>
          <template tid="FiberSwitchInEvent">
			<data inType="win:UInt64" name="FiberID" />
		  </template>			
		</templates>
        <keywords>
          <keyword name="HighFrequency" mask="0x2" />
          <keyword name="NormalFrequency" mask="0x1" />
        </keywords>
        <opcodes>
		  <opcode name="SetThreadNameOpcode" symbol="PerformanceAPI_SetThreadNameOpcode" value="14"/>
		  <opcode name="APIVersionOpcode" symbol="PerformanceAPI_APIVersionOpcode" value="15"/>
		  <opcode name="SetThreadNameNOpcode" symbol="PerformanceAPI_SetThreadNameNOpcode" value="16"/>
		  <opcode name="RegisterFiberOpcode" symbol="PerformanceAPI_RegisterFiberOpcode" value="17"/>
		  <opcode name="UnregisterFiberOpcode" symbol="PerformanceAPI_UnregisterFiberOpcode" value="18"/>
		  <opcode name="FiberSwitchOutOpcode" symbol="PerformanceAPI_FiberSwitchOutOpcode" value="19"/>
		  <opcode name="FiberSwitchInOpcode" symbol="PerformanceAPI_FiberSwitchInOpcode" value="20"/>			
		</opcodes>
        <tasks>
		  <task name="APIInfo" symbol="PerformanceAPI_APIInfo_Task" value="2" eventGUID="{21A3DC68-9F10-452D-9C64-CD1613393132}"/>
		  <task name="Fibers" symbol="PerformanceAPI_Fibers_Task" value="3" eventGUID="{E38A6D42-13A0-4391-BF51-077B73BBF17A}"/>			
        </tasks>
        <events>
		  <event symbol="PerformanceAPI_SetThreadName" template="SetThreadNameEvent" value="102" task="APIInfo" opcode="SetThreadNameOpcode" keywords="NormalFrequency" />
		  <event symbol="PerformanceAPI_APIVersion" template="APIVersionEvent" value="103" task="APIInfo" opcode="APIVersionOpcode" keywords="NormalFrequency" />
		  <event symbol="PerformanceAPI_SetThreadNameN" template="SetThreadNameNEvent" value="104" task="APIInfo" opcode="SetThreadNameNOpcode" keywords="NormalFrequency" />

		  <event symbol="PerformanceAPI_RegisterFiberInternal" template="RegisterFiberEvent" value="105" task="Fibers" opcode="RegisterFiberOpcode" keywords="NormalFrequency" />
		  <event symbol="PerformanceAPI_UnregisterFiberInternal" template="UnregisterFiberEvent" value="106" task="Fibers" opcode="UnregisterFiberOpcode" keywords="NormalFrequency" />
		  <event symbol="PerformanceAPI_FiberSwitchOutInternal" template="FiberSwitchOutEvent" value="107" task="Fibers" opcode="FiberSwitchOutOpcode" keywords="NormalFrequency" />
		  <event symbol="PerformanceAPI_FiberSwitchInInternal" template="FiberSwitchInEvent" value="108" task="Fibers" opcode="FiberSwitchInOpcode" keywords="NormalFrequency" />
        </events>
      </provider>		
    </events>
  </instrumentation>
</instrumentationManifest>
